/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package datasource;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class SingletonDataSource {
    private static DataSource singleDataSource;

    //No one is allowed to construct their own version of this class
    private SingletonDataSource() {
    }

    //Use the get method to fetch the instance if it already exists
    //or construct one if it doesn't.
    public static DataSource getInstance() {
        if (singleDataSource == null) {
            singleDataSource = new InMemoryDataSource();
        }
        return singleDataSource;
    }
}
